# Supplementary Materials Documentation

This repository contains files and folders related to the experiments, figures, and discussions for our **NeurIPS 2024 Saliency Paper**. Below is an overview of the contents:

## Main Files

- **Neurip2024_Saliency_Paper_Appendices.pdf**: Contains supplementary information and extended data analyses for the main paper.
- **Neurip2024_Saliency_Paper_Checklist.pdf**: Includes the checklist of requirements and criteria for NeurIPS 2024 submission.

## Figure Directories

Each folder labeled `Fig1` through `Fig8` contains files related to individual figures from the paper.

Main Body:

- **Fig1**: Vector graphics for Figure 1.
- **Fig2**: Vector graphics for Figure 2.
- **Fig3**: Vector graphics for Figure 3.
- **Fig4**: Vector graphics for Figure 4.
- **Fig5**: Vector graphics for Figure 5.

Appendices:

- **Fig6**: Vector graphics for Figure 6.
- **Fig7**: Vector graphics for Figure 7.
- **Fig8**: Vector graphics for Figure 8.

## New Experiments in Rebuttal and Discussion Periods

This folder contains additional experiments and discussions conducted during the rebuttal and discussion phase (https://openreview.net/forum?id=LPkcoml66W). Subfolders include:

- **Ablation study**: Contains files related to the ablation study, investigating the effects of disrupting various components of the model.
- **BSDS500_edge_response_pinwheels**: Includes data and results from experiments on edge response in pinwheel structures using the BSDS500 dataset.
- **BSDS500_edge_response_salt&peppers**: Contains data and analysis of edge responses in salt-and-pepper organizations, also using the BSDS500 dataset.
- **Discussion about different orientation bandwidths**: Documents discussing the impact of varying orientation bandwidths on model performance and neural response.
- **Discussion about local pixel and geometrical entropy**: Files containing analysis and discussions on the relationship between local pixel entropy and geometrical entropy.
